#include "DM814x_EVM.h"
#include "DM814x_types.h"
#include "DM814x_i2c.h"
#include "stdio.h"
#include "stdlib.h"

int main()
{
	STATUS u32Retval = SUCCESS;
	UINT8  u8SlaveAddr = 0x25;
	UINT8 numbytes;
	UINT8 data[2];
    UINT8 buffer[3];
    UINT16 busVoltage;
	buffer[0] = 10;		//MSP430 register offset for INA220 address select
    buffer[1] = 0x40;	//slave address of INA (U12)
    buffer[2] = 0x02;	//INA reg offset to read bus voltage
		
	u32Retval=DM814xI2cInit(0); 
 
 	if (SUCCESS != u32Retval )
	{
		printf("I2c initalization Failed\n" );
	}
	u32Retval = DM814xI2cProbe (0,u8SlaveAddr);
	if (SUCCESS == u32Retval )
	{
		printf("I2C address %x has been found\n", u8SlaveAddr);
	}
	else{
		
	 printf("I2C address %x has not been found\n", u8SlaveAddr);
	}

	DM814xI2cWite(0,(UINT16)u8SlaveAddr, buffer, 3, &numbytes );  // writing 0x45 to reg 10 and 0x02 to reg 11	
	DM814xI2cRead (0, u8SlaveAddr, data, 2, &numbytes);			  // reading the INA bus voltage from reg 12 and 13 of MSP430
	
	busVoltage = (data[0] << 8) | data[1];
	busVoltage = busVoltage >> 3;
	printf("bus voltage = %d mV\n", (busVoltage * 4));
		
	return 0;
}	 

	
 